/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Animation {
    private int frameWidth;
    private int frameHeight;
    private BufferedImage animImage;
    private int numberOfFrames;
    private long frameTime;
    private long startingFrameTime;
    private long timeForNextFrame;
    private int currentFrameNumber;
    private boolean loop;
    public int x;
    public int y;
    private int startingXOfFrameInImage;
    private int endingXOfFrameInImage;
    public boolean active;
    private long showDelay;
    private long timeOfAnimationCreation;

    public Animation(BufferedImage animImage, int frameWidth, int frameHeight, int numberOfFrames, long frameTime, boolean loop, int x, int y, long showDelay) {
        this.animImage = animImage;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.numberOfFrames = numberOfFrames;
        this.frameTime = frameTime;
        this.loop = loop;
        this.x = x;
        this.y = y;
        this.showDelay = showDelay;
        this.timeOfAnimationCreation = System.currentTimeMillis();
        this.startingXOfFrameInImage = 0;
        this.endingXOfFrameInImage = frameWidth;
        this.startingFrameTime = System.currentTimeMillis() + showDelay;
        this.timeForNextFrame = this.startingFrameTime + this.frameTime;
        this.currentFrameNumber = 0;
        this.active = true;
    }

    private void Update() {
        if (this.timeForNextFrame <= System.currentTimeMillis()) {
            ++this.currentFrameNumber;
            if (this.currentFrameNumber >= this.numberOfFrames) {
                this.currentFrameNumber = 0;
                if (!this.loop) {
                    this.active = false;
                }
            }
            this.startingXOfFrameInImage = this.currentFrameNumber * this.frameWidth;
            this.endingXOfFrameInImage = this.startingXOfFrameInImage + this.frameWidth;
            this.startingFrameTime = System.currentTimeMillis();
            this.timeForNextFrame = this.startingFrameTime + this.frameTime;
        }
    }

    public void changeCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void Draw(Graphics2D g2d) {
        this.Update();
        if (this.timeOfAnimationCreation + this.showDelay <= System.currentTimeMillis()) {
            g2d.drawImage(this.animImage, this.x, this.y, this.x + this.frameWidth, this.y + this.frameHeight, this.startingXOfFrameInImage, 0, this.endingXOfFrameInImage, this.frameHeight, null);
        }
    }
}

