/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import helowars.Game;
import helowars.UserInputControl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Framework
extends UserInputControl {
    public static int frameWidth;
    public static int frameHeight;
    public static final long secsInNanosecs = 1000000000L;
    public static final long milisecsInNanosecs = 1000000L;
    private final int GAME_FPS = 60;
    private final long GAME_UPDATE_PERIOD = 16666666L;
    public static GameplayState gameState;
    private long gameTime;
    private long lastTime;
    private Game game;
    private Font fontHeader;
    private Font fontBody;
    private BufferedImage titleScreenImage;
    private BufferedImage frameBorderImage;
    private BufferedImage skyImage;
    private BufferedImage clouds1Image;
    private BufferedImage clouds2Image;

    public Framework() {
        gameState = GameplayState.VISUALIZING;
        Thread gameThread = new Thread(){

            @Override
            public void run() {
                Framework.this.GameLoop();
            }
        };
        gameThread.start();
    }

    private void Initialize() {
        this.fontHeader = new Font("Monospaced", 1, 40);
        this.fontBody = new Font("Serif", 0, 20);
    }

    private void LoadContent() {
        try {
            URL frameBorderPath = this.getClass().getResource("/helowars/resources/frame_border.png");
            this.frameBorderImage = ImageIO.read(frameBorderPath);
            URL skyPath = this.getClass().getResource("/helowars/resources/sky.jpg");
            this.skyImage = ImageIO.read(skyPath);
            URL titleScreenPath = this.getClass().getResource("/helowars/resources/TitleScreen.png");
            this.titleScreenImage = ImageIO.read(titleScreenPath);
            URL clouds1Path = this.getClass().getResource("/helowars/resources/clouds1.png");
            this.clouds1Image = ImageIO.read(clouds1Path);
            URL clouds2Path = this.getClass().getResource("/helowars/resources/clouds2.png");
            this.clouds2Image = ImageIO.read(clouds2Path);
        }
        catch (IOException ex) {
            Logger.getLogger(Framework.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void GameLoop() {
        long visualizingTime = 0L;
        long lastVisualizingTime = System.nanoTime();
        while (true) {
            long beginTime = System.nanoTime();
            switch (gameState) {
                case PLAYING: {
                    this.gameTime += System.nanoTime() - this.lastTime;
                    this.game.UpdateGame(this.gameTime, this.mousePosition());
                    this.lastTime = System.nanoTime();
                    break;
                }
                case GAMEOVER: {
                    break;
                }
                case MAIN_MENU: {
                    break;
                }
                case OPTIONS: {
                    break;
                }
                case GAME_LOADING: {
                    break;
                }
                case STARTING: {
                    this.Initialize();
                    this.LoadContent();
                    gameState = GameplayState.MAIN_MENU;
                    break;
                }
                case VISUALIZING: {
                    if (this.getWidth() > 1 && visualizingTime > 1000000000L) {
                        frameWidth = this.getWidth();
                        frameHeight = this.getHeight();
                        gameState = GameplayState.STARTING;
                        break;
                    }
                    visualizingTime += System.nanoTime() - lastVisualizingTime;
                    lastVisualizingTime = System.nanoTime();
                }
            }
            this.repaint();
            long timeTaken = System.nanoTime() - beginTime;
            long timeLeft = (16666666L - timeTaken) / 1000000L;
            if (timeLeft < 10L) {
                timeLeft = 10L;
            }
            try {
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void Draw(Graphics2D g2d) {
        switch (gameState) {
            case PLAYING: {
                this.game.Draw(g2d, this.mousePosition(), this.gameTime);
                break;
            }
            case GAMEOVER: {
                this.drawMenuBackground(g2d);
                g2d.setColor(Color.black);
                g2d.setFont(this.fontBody);
                g2d.drawString("Press ENTER to restart or ESC to exit.", frameWidth / 2 - 160, frameHeight / 4 + 50);
                this.game.drawStats(g2d, this.gameTime);
                g2d.setFont(this.fontHeader);
                g2d.drawString("GAME OVER", frameWidth / 2 - 120, frameHeight / 4);
                break;
            }
            case MAIN_MENU: {
                this.drawMenuBackground(g2d);
                g2d.drawImage((Image)this.titleScreenImage, frameWidth / 2 - this.titleScreenImage.getWidth() / 2, frameHeight / 2 - this.titleScreenImage.getHeight() / 2, null);
                g2d.setColor(Color.black);
                break;
            }
            case OPTIONS: {
                break;
            }
            case GAME_LOADING: {
                g2d.setColor(Color.white);
                g2d.drawString("LOADING...", frameWidth / 2 - 50, frameHeight / 2);
            }
        }
    }

    private void newGame() {
        this.gameTime = 0L;
        this.lastTime = System.nanoTime();
        this.game = new Game();
    }

    private void restartGame() {
        this.gameTime = 0L;
        this.lastTime = System.nanoTime();
        this.game.restartGame();
        gameState = GameplayState.PLAYING;
    }

    private Point mousePosition() {
        try {
            Point mp = this.getMousePosition();
            if (mp != null) {
                return this.getMousePosition();
            }
            return new Point(0, 0);
        }
        catch (Exception e) {
            return new Point(0, 0);
        }
    }

    @Override
    public void keyReleasedFramework(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            System.exit(0);
        }
        switch (gameState) {
            case GAMEOVER: {
                if (e.getKeyCode() != 10) break;
                this.restartGame();
                break;
            }
            case MAIN_MENU: {
                this.newGame();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void drawMenuBackground(Graphics2D g2d) {
        g2d.drawImage(this.skyImage, 0, 0, frameWidth, frameHeight, null);
        g2d.drawImage(this.clouds1Image, 0, 0, frameWidth, frameHeight, null);
        g2d.drawImage(this.clouds2Image, 0, 0, frameWidth, frameHeight, null);
        g2d.drawImage(this.frameBorderImage, 0, 0, frameWidth, frameHeight, null);
        g2d.setColor(Color.white);
        g2d.drawString("ADARSHKUMAR PAVANI", 7, frameHeight - 5);
    }

    public static enum GameplayState {
        STARTING,
        VISUALIZING,
        GAME_LOADING,
        MAIN_MENU,
        OPTIONS,
        PLAYING,
        GAMEOVER,
        DESTROYED;

    }
}

