/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import helowars.Animation;
import helowars.Background;
import helowars.Framework;
import helowars.Missile;
import helowars.MissileSmoke;
import helowars.OpponentChopper;
import helowars.Pellet;
import helowars.PlayerChopper;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Game {
    Random random;
    Robot robot;
    PlayerChopper player;
    private ArrayList<OpponentChopper> opponentChopperList = new ArrayList();
    private ArrayList<Animation> explosionsList;
    private BufferedImage explosionImage;
    private ArrayList<Pellet> pelletsList;
    private ArrayList<Missile> missilesList;
    private ArrayList<MissileSmoke> missilesSmokeList;
    private BufferedImage skyImage;
    private BufferedImage clouds1Image;
    private BufferedImage clouds2Image;
    private BufferedImage mountainsImage;
    private BufferedImage grassImage;
    private Background clouds1Scrolling;
    private Background clouds2Scrolling;
    private Background mountainsScrolling;
    private Background grassScrolling;
    private BufferedImage mousePointerImage;
    private Font font;
    private int escapedOpponents;
    private int destroyedOpponents;

    public Game() {
        Framework.gameState = Framework.GameplayState.GAME_LOADING;
        Thread threadForInitGame = new Thread(){

            @Override
            public void run() {
                Game.this.initialize();
                Game.this.LoadGameContent();
                Framework.gameState = Framework.GameplayState.PLAYING;
            }
        };
        threadForInitGame.start();
    }

    private void initialize() {
        this.random = new Random();
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.player = new PlayerChopper(Framework.frameWidth / 4, Framework.frameHeight / 4);
        this.opponentChopperList = new ArrayList();
        this.explosionsList = new ArrayList();
        this.pelletsList = new ArrayList();
        this.missilesList = new ArrayList();
        this.missilesSmokeList = new ArrayList();
        this.clouds1Scrolling = new Background();
        this.clouds2Scrolling = new Background();
        this.mountainsScrolling = new Background();
        this.grassScrolling = new Background();
        this.font = new Font("Monospaced", 1, 18);
        this.escapedOpponents = 0;
        this.destroyedOpponents = 0;
    }

    private void LoadGameContent() {
        try {
            URL skyPath = this.getClass().getResource("/helowars/resources/sky.jpg");
            this.skyImage = ImageIO.read(skyPath);
            URL clouds1Path = this.getClass().getResource("/helowars/resources/clouds1.png");
            this.clouds1Image = ImageIO.read(clouds1Path);
            URL clouds2Path = this.getClass().getResource("/helowars/resources/clouds2.png");
            this.clouds2Image = ImageIO.read(clouds2Path);
            URL mountainsPath = this.getClass().getResource("/helowars/resources/mountains.png");
            this.mountainsImage = ImageIO.read(mountainsPath);
            URL grassPath = this.getClass().getResource("/helowars/resources/grass.png");
            this.grassImage = ImageIO.read(grassPath);
            URL opponentChopperPath = this.getClass().getResource("/helowars/resources/opponent_chopper_body.png");
            OpponentChopper.opponentChopperImage = ImageIO.read(opponentChopperPath);
            URL topPropellerPath = this.getClass().getResource("/helowars/resources/opponent_top_propeller_animation.png");
            OpponentChopper.topPropellerImage = ImageIO.read(topPropellerPath);
            URL backPropellerPath = this.getClass().getResource("/helowars/resources/opponent_back_propeller_animation.png");
            OpponentChopper.backPropellerImage = ImageIO.read(backPropellerPath);
            URL missilePath = this.getClass().getResource("/helowars/resources/missile.png");
            Missile.missileImage = ImageIO.read(missilePath);
            URL missileSmokePath = this.getClass().getResource("/helowars/resources/missile_smoke.png");
            MissileSmoke.smokeImage = ImageIO.read(missileSmokePath);
            URL explosionAnimImgUrl = this.getClass().getResource("/helowars/resources/explosion.png");
            this.explosionImage = ImageIO.read(explosionAnimImgUrl);
            URL mousePointerPath = this.getClass().getResource("/helowars/resources/mouse_pointer.png");
            this.mousePointerImage = ImageIO.read(mousePointerPath);
            URL pelletPath = this.getClass().getResource("/helowars/resources/pellet.png");
            Pellet.pelletImg = ImageIO.read(pelletPath);
        }
        catch (IOException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.clouds1Scrolling.Initialize(this.clouds1Image, -6.0, 0);
        this.clouds2Scrolling.Initialize(this.clouds2Image, -2.0, 0);
        this.mountainsScrolling.Initialize(this.mountainsImage, -1.0, Framework.frameHeight - this.grassImage.getHeight() - this.mountainsImage.getHeight() + 40);
        this.grassScrolling.Initialize(this.grassImage, -1.2, Framework.frameHeight - this.grassImage.getHeight());
    }

    public void UpdateGame(long gameTime, Point mousePosition) {
        if (!this.isPlayerAlive() && this.explosionsList.isEmpty()) {
            Framework.gameState = Framework.GameplayState.GAMEOVER;
            return;
        }
        if (this.player.numberOfAmmo <= 0 && this.player.numberOfMissiles <= 0 && this.pelletsList.isEmpty() && this.missilesList.isEmpty() && this.explosionsList.isEmpty()) {
            Framework.gameState = Framework.GameplayState.GAMEOVER;
            return;
        }
        if (this.isPlayerAlive()) {
            this.isPlayerShooting(gameTime, mousePosition);
            this.isMissileFired(gameTime);
            this.player.isMoving();
            this.player.Update();
        }
        this.limitMousePosition(mousePosition);
        this.updatePellets();
        this.updateMissiles(gameTime);
        this.updateMissileSmoke(gameTime);
        this.createOpponentChopper(gameTime);
        this.updateOpponents();
        this.updateExplosions();
    }

    public void Draw(Graphics2D g2d, Point mousePosition, long gameTime) {
        g2d.drawImage(this.skyImage, 0, 0, Framework.frameWidth, Framework.frameHeight, null);
        this.mountainsScrolling.Draw(g2d);
        this.grassScrolling.Draw(g2d);
        this.clouds2Scrolling.Draw(g2d);
        if (this.isPlayerAlive()) {
            this.player.Draw(g2d);
        }
        int i = 0;
        while (i < this.opponentChopperList.size()) {
            this.opponentChopperList.get(i).Draw(g2d);
            ++i;
        }
        i = 0;
        while (i < this.pelletsList.size()) {
            this.pelletsList.get(i).Draw(g2d);
            ++i;
        }
        i = 0;
        while (i < this.missilesList.size()) {
            this.missilesList.get(i).Draw(g2d);
            ++i;
        }
        i = 0;
        while (i < this.missilesSmokeList.size()) {
            this.missilesSmokeList.get(i).Draw(g2d);
            ++i;
        }
        i = 0;
        while (i < this.explosionsList.size()) {
            this.explosionsList.get(i).Draw(g2d);
            ++i;
        }
        g2d.setFont(this.font);
        g2d.setColor(Color.darkGray);
        g2d.drawString(Game.formatTime(gameTime), Framework.frameWidth / 2 - 45, 21);
        g2d.drawString("DESTROYED: " + this.destroyedOpponents, 10, 21);
        g2d.drawString("ESCAPED: " + this.escapedOpponents, 10, 41);
        g2d.drawString("MISSILES: " + this.player.numberOfMissiles, 10, 81);
        g2d.drawString("AMMO: " + this.player.numberOfAmmo, 10, 101);
        this.clouds1Scrolling.Draw(g2d);
        if (this.isPlayerAlive()) {
            this.drawRotatingMousePointer(g2d, mousePosition);
        }
    }

    private void createOpponentChopper(long gameTime) {
        if (gameTime - OpponentChopper.timeOfLastCreatedOpponent >= OpponentChopper.timeBetweenNewOpponents) {
            OpponentChopper oh = new OpponentChopper();
            int xCoordinate = Framework.frameWidth;
            int yCoordinate = this.random.nextInt(Framework.frameHeight - OpponentChopper.opponentChopperImage.getHeight());
            oh.Initialize(xCoordinate, yCoordinate);
            this.opponentChopperList.add(oh);
            OpponentChopper.speedUp();
            OpponentChopper.timeOfLastCreatedOpponent = gameTime;
        }
    }

    private void drawRotatingMousePointer(Graphics2D g2d, Point mousePosition) {
        double RIGHT_ANGLE_RADIANS = 1.5707963267948966;
        int pivotX = this.player.gunXcoordinate;
        int pivotY = this.player.gunYcoordinate;
        int a = pivotX - mousePosition.x;
        int b = pivotY - mousePosition.y;
        double ab = (double)a / (double)b;
        double alfaAngleRadians = Math.atan(ab);
        alfaAngleRadians = mousePosition.y < pivotY ? RIGHT_ANGLE_RADIANS - alfaAngleRadians - RIGHT_ANGLE_RADIANS * 2.0 : (mousePosition.y > pivotY ? RIGHT_ANGLE_RADIANS - alfaAngleRadians : 0.0);
        AffineTransform origXform = g2d.getTransform();
        AffineTransform newXform = (AffineTransform)origXform.clone();
        newXform.rotate(alfaAngleRadians, mousePosition.x, mousePosition.y);
        g2d.setTransform(newXform);
        g2d.drawImage((Image)this.mousePointerImage, mousePosition.x, mousePosition.y - this.mousePointerImage.getHeight() / 2, null);
        g2d.setTransform(origXform);
    }

    private static String formatTime(long time) {
        int sec = (int)(time / 1000000L / 1000L);
        int min = sec / 60;
        String minString = min <= 9 ? "0" + Integer.toString(min) : Integer.toString(min);
        String secString = sec <= 9 ? "0" + Integer.toString(sec) : Integer.toString(sec -= min * 60);
        return String.valueOf(minString) + ":" + secString;
    }

    private boolean isPlayerAlive() {
        return this.player.health > 0;
    }

    private void isPlayerShooting(long gameTime, Point mousePosition) {
        if (this.player.isFiring(gameTime)) {
            Pellet.timeOfLastCreatedPellet = gameTime;
            --this.player.numberOfAmmo;
            Pellet b = new Pellet(this.player.gunXcoordinate, this.player.gunYcoordinate, mousePosition);
            this.pelletsList.add(b);
        }
    }

    private void isMissileFired(long gameTime) {
        if (this.player.isFiredMissile(gameTime)) {
            Missile.timeOfLastSpawnedMissile = gameTime;
            --this.player.numberOfMissiles;
            Missile r = new Missile();
            r.Initialize(this.player.missileHolderXcoordinate, this.player.missileHolderYcoordinate);
            this.missilesList.add(r);
        }
    }

    private void updateOpponents() {
        int i = 0;
        while (i < this.opponentChopperList.size()) {
            OpponentChopper oc = this.opponentChopperList.get(i);
            oc.Update();
            Rectangle playerRectangel = new Rectangle(this.player.xCoordinate, this.player.yCoordinate, this.player.playerChopperImage.getWidth(), this.player.playerChopperImage.getHeight());
            Rectangle opponentRectangel = new Rectangle(oc.xCoordinate, oc.yCoordinate, OpponentChopper.opponentChopperImage.getWidth(), OpponentChopper.opponentChopperImage.getHeight());
            if (playerRectangel.intersects(opponentRectangel)) {
                Animation expAnimation;
                this.player.health = 0;
                this.opponentChopperList.remove(i);
                int exNum = 0;
                while (exNum < 3) {
                    expAnimation = new Animation(this.explosionImage, 134, 134, 12, 45L, false, this.player.xCoordinate + exNum * 60, this.player.yCoordinate - this.random.nextInt(100), exNum * 200 + this.random.nextInt(100));
                    this.explosionsList.add(expAnimation);
                    ++exNum;
                }
                exNum = 0;
                while (exNum < 3) {
                    expAnimation = new Animation(this.explosionImage, 134, 134, 12, 45L, false, oc.xCoordinate + exNum * 60, oc.yCoordinate - this.random.nextInt(100), exNum * 200 + this.random.nextInt(100));
                    this.explosionsList.add(expAnimation);
                    ++exNum;
                }
                break;
            }
            if (oc.health <= 0) {
                Animation expAnimation = new Animation(this.explosionImage, 134, 134, 12, 45L, false, oc.xCoordinate, oc.yCoordinate - this.explosionImage.getHeight() / 3, 0L);
                this.explosionsList.add(expAnimation);
                ++this.destroyedOpponents;
                this.opponentChopperList.remove(i);
            } else if (oc.isOutOfScreen()) {
                this.opponentChopperList.remove(i);
                ++this.escapedOpponents;
            }
            ++i;
        }
    }

    private void updatePellets() {
        int i = 0;
        while (i < this.pelletsList.size()) {
            Pellet pellet = this.pelletsList.get(i);
            pellet.Update();
            if (pellet.isItOutOfScreen()) {
                this.pelletsList.remove(i);
            } else {
                Rectangle pelletRectangle = new Rectangle((int)pellet.xCoordinate, (int)pellet.yCoordinate, Pellet.pelletImg.getWidth(), Pellet.pelletImg.getHeight());
                int j = 0;
                while (j < this.opponentChopperList.size()) {
                    OpponentChopper oc = this.opponentChopperList.get(j);
                    Rectangle opponentRectangel = new Rectangle(oc.xCoordinate, oc.yCoordinate, OpponentChopper.opponentChopperImage.getWidth(), OpponentChopper.opponentChopperImage.getHeight());
                    if (pelletRectangle.intersects(opponentRectangel)) {
                        oc.health -= Pellet.damagePower;
                        this.pelletsList.remove(i);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateMissiles(long gameTime) {
        int i = 0;
        while (i < this.missilesList.size()) {
            Missile missile = this.missilesList.get(i);
            missile.Update();
            if (missile.isItOutOfScreen()) {
                this.missilesList.remove(i);
            } else {
                MissileSmoke ms = new MissileSmoke();
                int xCoordinate = missile.xCoordinate - MissileSmoke.smokeImage.getWidth();
                int yCoordinte = missile.yCoordinate - 5 + this.random.nextInt(6);
                ms.Initialize(xCoordinate, yCoordinte, gameTime, missile.currentSmokeLifeTime);
                this.missilesSmokeList.add(ms);
                int smokePositionX = 5 + this.random.nextInt(8);
                ms = new MissileSmoke();
                xCoordinate = missile.xCoordinate - MissileSmoke.smokeImage.getWidth() + smokePositionX;
                yCoordinte = missile.yCoordinate - 5 + this.random.nextInt(6);
                ms.Initialize(xCoordinate, yCoordinte, gameTime, missile.currentSmokeLifeTime);
                this.missilesSmokeList.add(ms);
                missile.currentSmokeLifeTime = (long)((double)missile.currentSmokeLifeTime * 1.02);
                if (this.checkIfMissileHitOpponent(missile)) {
                    this.missilesList.remove(i);
                }
            }
            ++i;
        }
    }

    private boolean checkIfMissileHitOpponent(Missile missile) {
        boolean didItHitOpponent = false;
        Rectangle missileRectangle = new Rectangle(missile.xCoordinate, missile.yCoordinate, 2, Missile.missileImage.getHeight());
        int j = 0;
        while (j < this.opponentChopperList.size()) {
            OpponentChopper oc = this.opponentChopperList.get(j);
            Rectangle opponentRectangel = new Rectangle(oc.xCoordinate, oc.yCoordinate, OpponentChopper.opponentChopperImage.getWidth(), OpponentChopper.opponentChopperImage.getHeight());
            if (missileRectangle.intersects(opponentRectangel)) {
                didItHitOpponent = true;
                oc.health -= Missile.damagePower;
                break;
            }
            ++j;
        }
        return didItHitOpponent;
    }

    private void updateMissileSmoke(long gameTime) {
        int i = 0;
        while (i < this.missilesSmokeList.size()) {
            MissileSmoke ms = this.missilesSmokeList.get(i);
            if (ms.didSmokeDisapper(gameTime)) {
                this.missilesSmokeList.remove(i);
            }
            ms.updateTransparency(gameTime);
            ++i;
        }
    }

    private void updateExplosions() {
        int i = 0;
        while (i < this.explosionsList.size()) {
            if (!this.explosionsList.get((int)i).active) {
                this.explosionsList.remove(i);
            }
            ++i;
        }
    }

    private void limitMousePosition(Point mousePosition) {
        int maxYcoordinateDistanceFromPlayer_top = 30;
        int maxYcoordinateDistanceFromPlayer_bottom = 120;
        int mouseXcoordinate = this.player.gunXcoordinate + 250;
        int mouseYcoordinate = mousePosition.y;
        if (mousePosition.y < this.player.gunYcoordinate) {
            if (mousePosition.y < this.player.gunYcoordinate - maxYcoordinateDistanceFromPlayer_top) {
                mouseYcoordinate = this.player.gunYcoordinate - maxYcoordinateDistanceFromPlayer_top;
            }
        } else if (mousePosition.y > this.player.gunYcoordinate + maxYcoordinateDistanceFromPlayer_bottom) {
            mouseYcoordinate = this.player.gunYcoordinate + maxYcoordinateDistanceFromPlayer_bottom;
        }
        mouseYcoordinate = (int)((double)mouseYcoordinate + this.player.movingYspeed);
        this.robot.mouseMove(mouseXcoordinate, mouseYcoordinate);
    }

    public void drawStats(Graphics2D g2d, long gameTime) {
        g2d.drawString("Time Elapsed: " + Game.formatTime(gameTime), Framework.frameWidth / 2 - 100, Framework.frameHeight / 3 + 120);
        g2d.drawString("Missiles left: " + this.player.numberOfMissiles, Framework.frameWidth / 2 - 75, Framework.frameHeight / 3 + 160);
        g2d.drawString("Ammo left: " + this.player.numberOfAmmo, Framework.frameWidth / 2 - 78, Framework.frameHeight / 3 + 190);
        g2d.drawString("Opponents Destroyed: " + this.destroyedOpponents, Framework.frameWidth / 2 - 100, Framework.frameHeight / 3 + 230);
        g2d.drawString("Opponents Escaped: " + this.escapedOpponents, Framework.frameWidth / 2 - 95, Framework.frameHeight / 3 + 260);
        g2d.setFont(new Font("Monospaced", 1, 30));
        g2d.drawString("STATS: ", Framework.frameWidth / 2 - 60, Framework.frameHeight / 3 + 80);
    }

    public void restartGame() {
        this.player.Reset(Framework.frameWidth / 4, Framework.frameHeight / 4);
        OpponentChopper.restartOpponent();
        Pellet.timeOfLastCreatedPellet = 0L;
        Missile.timeOfLastSpawnedMissile = 0L;
        this.opponentChopperList.clear();
        this.pelletsList.clear();
        this.missilesList.clear();
        this.missilesSmokeList.clear();
        this.explosionsList.clear();
        this.escapedOpponents = 0;
        this.destroyedOpponents = 0;
    }
}

