/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class MissileSmoke {
    private int xCoordinate;
    private int yCoordinate;
    public long smokeLifeTime;
    public long timeOfCreation;
    public static BufferedImage smokeImage;
    public float imageTransparency;

    public void Initialize(int xCoordinate, int yCoordinate, long elapsedGameTime, long smokeLifeTime) {
        this.timeOfCreation = elapsedGameTime;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.smokeLifeTime = smokeLifeTime;
        this.imageTransparency = 1.0f;
    }

    public boolean didSmokeDisapper(long elapsedGameTime) {
        long currentLifeTime = elapsedGameTime - this.timeOfCreation;
        return currentLifeTime >= this.smokeLifeTime;
    }

    public void Draw(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.imageTransparency));
        float imageMultiplier = 2.0f - this.imageTransparency;
        int newImageWidth = (int)((float)smokeImage.getWidth() * imageMultiplier);
        int newImageHeight = (int)((float)smokeImage.getHeight() * imageMultiplier);
        int newImageYCoordinate = (int)((float)(smokeImage.getHeight() / 2) * (1.0f - this.imageTransparency));
        g2d.drawImage(smokeImage, this.xCoordinate, this.yCoordinate - newImageYCoordinate, newImageWidth, newImageHeight, null);
        g2d.setComposite(AlphaComposite.getInstance(3));
    }

    public void updateTransparency(long elapsedGameTime) {
        long currentLifeTime = elapsedGameTime - this.timeOfCreation;
        int currentLTInPercentages = (int)(currentLifeTime * 100L / this.smokeLifeTime);
        float mSmokeTransparency = 1.0f * ((float)(currentLTInPercentages = 100 - currentLTInPercentages) * 0.01f);
        if (mSmokeTransparency > 0.0f) {
            this.imageTransparency = mSmokeTransparency;
        }
    }
}

