/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import helowars.Animation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class OpponentChopper {
    private static final long timeBetweenNewOpponentsInit = 3000000000L;
    public static long timeBetweenNewOpponents = 3000000000L;
    public static long timeOfLastCreatedOpponent = 0L;
    public int health;
    public int xCoordinate;
    public int yCoordinate;
    private static final double movingXspeedInit = -4.0;
    private static double movingXspeed = -4.0;
    public static BufferedImage opponentChopperImage;
    public static BufferedImage topPropellerImage;
    public static BufferedImage backPropellerImage;
    private Animation toptPropellerAnimation;
    private Animation backPropellerAnimation;
    private static int offsetXTopPropeller;
    private static int offsetYTopPropeller;
    private static int offsetXBackPropeller;
    private static int offsetYBackPropeller;

    static {
        offsetXTopPropeller = 4;
        offsetYTopPropeller = -7;
        offsetXBackPropeller = 200;
        offsetYBackPropeller = -16;
    }

    public void Initialize(int xCoordinate, int yCoordinate) {
        this.health = 100;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.toptPropellerAnimation = new Animation(topPropellerImage, 158, 16, 3, 20L, true, xCoordinate + offsetXTopPropeller, yCoordinate + offsetYTopPropeller, 0L);
        this.backPropellerAnimation = new Animation(backPropellerImage, 47, 47, 10, 5L, true, xCoordinate + offsetXBackPropeller, yCoordinate + offsetYBackPropeller, 0L);
        movingXspeed = -4.0;
    }

    public boolean isOutOfScreen() {
        return this.xCoordinate < 0 - opponentChopperImage.getWidth();
    }

    public void Update() {
        this.xCoordinate = (int)((double)this.xCoordinate + movingXspeed);
        this.toptPropellerAnimation.changeCoordinates(this.xCoordinate + offsetXTopPropeller, this.yCoordinate + offsetYTopPropeller);
        this.backPropellerAnimation.changeCoordinates(this.xCoordinate + offsetXBackPropeller, this.yCoordinate + offsetYBackPropeller);
    }

    public static void speedUp() {
        if (timeBetweenNewOpponents > 1000000000L) {
            timeBetweenNewOpponents -= 10000000L;
        }
        movingXspeed -= 0.25;
    }

    public void Draw(Graphics2D g2d) {
        this.toptPropellerAnimation.Draw(g2d);
        g2d.drawImage((Image)opponentChopperImage, this.xCoordinate, this.yCoordinate, null);
        this.backPropellerAnimation.Draw(g2d);
    }

    public static void restartOpponent() {
        timeBetweenNewOpponents = 3000000000L;
        timeOfLastCreatedOpponent = 0L;
        movingXspeed = -4.0;
    }
}

