/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import helowars.Animation;
import helowars.Missile;
import helowars.Pellet;
import helowars.UserInputControl;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PlayerChopper {
    private final int healthInit = 100;
    public int health;
    public int xCoordinate;
    public int yCoordinate;
    private double movingXspeed;
    private double acceleratingXspeed;
    private double acceleratingYspeed;
    private double stoppingXspeed;
    private double stoppingYspeed;
    public double movingYspeed;
    private final int numberOfMissilesInit = 80;
    public int numberOfMissiles;
    private final int numberOfAmmoInit = 1400;
    public int numberOfAmmo;
    public BufferedImage playerChopperImage;
    public BufferedImage topPropellerImage;
    public BufferedImage backPropellerImage;
    private Animation topPropellerAnimation;
    private Animation backPropellerAnimation;
    private int offsetXTopPropeller;
    private int offsetYTopPropeller;
    private int offsetXBackPropeller;
    private int offsetYBackPropeller;
    private int offsetXMissileHolder;
    private int offsetYMissileHolder;
    public int missileHolderXcoordinate;
    public int missileHolderYcoordinate;
    private int offsetXGun;
    private int offsetYGun;
    public int gunXcoordinate;
    public int gunYcoordinate;

    public PlayerChopper(int xCoordinate, int yCoordinate) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.loadContent();
        this.initialize();
    }

    private void initialize() {
        this.health = 100;
        this.numberOfMissiles = 80;
        this.numberOfAmmo = 1400;
        this.movingXspeed = 0.0;
        this.movingYspeed = 0.0;
        this.acceleratingXspeed = 0.2;
        this.acceleratingYspeed = 0.2;
        this.stoppingXspeed = 0.1;
        this.stoppingYspeed = 0.1;
        this.offsetXTopPropeller = 63;
        this.offsetYTopPropeller = -27;
        this.offsetXBackPropeller = -14;
        this.offsetYBackPropeller = -17;
        this.offsetXMissileHolder = 138;
        this.offsetYMissileHolder = 40;
        this.missileHolderXcoordinate = this.xCoordinate + this.offsetXMissileHolder;
        this.missileHolderYcoordinate = this.yCoordinate + this.offsetYMissileHolder;
        this.offsetXGun = this.playerChopperImage.getWidth() - 40;
        this.offsetYGun = this.playerChopperImage.getHeight();
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
    }

    private void loadContent() {
        try {
            URL playerChopperPath = this.getClass().getResource("/helowars/resources/player_chopper_body.png");
            this.playerChopperImage = ImageIO.read(playerChopperPath);
            URL topPropellerPath = this.getClass().getResource("/helowars/resources/player_top_propeller_animation.png");
            this.topPropellerImage = ImageIO.read(topPropellerPath);
            URL backPropellerPath = this.getClass().getResource("/helowars/resources/player_back_propeller_animation.png");
            this.backPropellerImage = ImageIO.read(backPropellerPath);
        }
        catch (IOException ex) {
            Logger.getLogger(PlayerChopper.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.topPropellerAnimation = new Animation(this.topPropellerImage, 204, 34, 3, 20L, true, this.xCoordinate + this.offsetXTopPropeller, this.yCoordinate + this.offsetYTopPropeller, 0L);
        this.backPropellerAnimation = new Animation(this.backPropellerImage, 54, 54, 4, 20L, true, this.xCoordinate + this.offsetXBackPropeller, this.yCoordinate + this.offsetYBackPropeller, 0L);
    }

    public boolean isFiring(long gameTime) {
        return UserInputControl.mouseButtonState(1) && gameTime - Pellet.timeOfLastCreatedPellet >= 100000000L && this.numberOfAmmo > 0;
    }

    public boolean isFiredMissile(long gameTime) {
        return UserInputControl.mouseButtonState(3) && gameTime - Missile.timeOfLastSpawnedMissile >= 250000000L && this.numberOfMissiles > 0;
    }

    public void isMoving() {
        if (UserInputControl.keyboardKeyState(68) || UserInputControl.keyboardKeyState(39)) {
            this.movingXspeed += this.acceleratingXspeed;
        } else if (UserInputControl.keyboardKeyState(65) || UserInputControl.keyboardKeyState(37)) {
            this.movingXspeed -= this.acceleratingXspeed;
        } else if (this.movingXspeed < 0.0) {
            this.movingXspeed += this.stoppingXspeed;
        } else if (this.movingXspeed > 0.0) {
            this.movingXspeed -= this.stoppingXspeed;
        }
        if (UserInputControl.keyboardKeyState(87) || UserInputControl.keyboardKeyState(38)) {
            this.movingYspeed -= this.acceleratingYspeed;
        } else if (UserInputControl.keyboardKeyState(83) || UserInputControl.keyboardKeyState(40)) {
            this.movingYspeed += this.acceleratingYspeed;
        } else if (this.movingYspeed < 0.0) {
            this.movingYspeed += this.stoppingYspeed;
        } else if (this.movingYspeed > 0.0) {
            this.movingYspeed -= this.stoppingYspeed;
        }
    }

    public void Update() {
        this.xCoordinate = (int)((double)this.xCoordinate + this.movingXspeed);
        this.yCoordinate = (int)((double)this.yCoordinate + this.movingYspeed);
        this.topPropellerAnimation.changeCoordinates(this.xCoordinate + this.offsetXTopPropeller, this.yCoordinate + this.offsetYTopPropeller);
        this.backPropellerAnimation.changeCoordinates(this.xCoordinate + this.offsetXBackPropeller, this.yCoordinate + this.offsetYBackPropeller);
        this.missileHolderXcoordinate = this.xCoordinate + this.offsetXMissileHolder;
        this.missileHolderYcoordinate = this.yCoordinate + this.offsetYMissileHolder;
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
    }

    public void Draw(Graphics2D g2d) {
        this.topPropellerAnimation.Draw(g2d);
        this.backPropellerAnimation.Draw(g2d);
        g2d.drawImage((Image)this.playerChopperImage, this.xCoordinate, this.yCoordinate, null);
    }

    public void Reset(int xCoordinate, int yCoordinate) {
        this.health = 100;
        this.numberOfMissiles = 80;
        this.numberOfAmmo = 1400;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
        this.movingXspeed = 0.0;
        this.movingYspeed = 0.0;
    }
}

