/*
 * Decompiled with CFR 0.152.
 */
package helowars;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class UserInputControl
extends JPanel
implements KeyListener,
MouseListener {
    private static boolean[] keyboardState = new boolean[525];
    private static boolean[] mouseState = new boolean[3];

    public UserInputControl() {
        this.setDoubleBuffered(true);
        this.setFocusable(true);
        this.setBackground(Color.black);
        BufferedImage blankCursorImg = new BufferedImage(16, 16, 2);
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(blankCursorImg, new Point(0, 0), null);
        this.setCursor(blankCursor);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public static boolean keyboardKeyState(int key) {
        return keyboardState[key];
    }

    @Override
    public void keyPressed(KeyEvent e) {
        UserInputControl.keyboardState[e.getKeyCode()] = true;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        UserInputControl.keyboardState[e.getKeyCode()] = false;
        this.keyReleasedFramework(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public abstract void keyReleasedFramework(KeyEvent var1);

    public static boolean mouseButtonState(int button) {
        return mouseState[button - 1];
    }

    private void mouseKeyStatus(MouseEvent e, boolean status) {
        if (e.getButton() == 1) {
            UserInputControl.mouseState[0] = status;
        } else if (e.getButton() == 2) {
            UserInputControl.mouseState[1] = status;
        } else if (e.getButton() == 3) {
            UserInputControl.mouseState[2] = status;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseKeyStatus(e, true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseKeyStatus(e, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public abstract void Draw(Graphics2D var1);

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        this.Draw(g2d);
    }
}

