package helowars;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/**
 * Creates frame and set its properties.
 * 
 * @author Adarshkumar Pavani
 */

public class Main extends JFrame{

	private Main()
    {
        // setting the title for this window.
        this.setTitle("Helo Wars");
        
        // setting size of the frame.
        if(true) // "true" for full screen
        {
            this.setUndecorated(true);
            // full screen.
            this.setExtendedState(this.MAXIMIZED_BOTH);
        }
        else // custom size for window
        {
            // Size of the window
            this.setSize(1024, 768);
            // setting the window to the center of the screen
            this.setLocationRelativeTo(null);
            // disabling the option to resize
            this.setResizable(false);
        }
        
        // exit the application when user closes the frame.
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        // creating the instance of the Framework.java that extends the UserInputControl.java and puts it on the frame.
        this.setContentPane(new Framework());
        
        this.setVisible(true);
    }

    public static void main(String[] args)
    {
        // Using event dispatch thread to build the UI
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                new Main();
            }
        });
    }
}
