package helowars;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

/**
 * Missile data
 * @author Adarshkumar Pavani
 */

public class Missile {
    
    // time between 2 missiles
    public final static long timeBetweenNewMissiles = Framework.secsInNanosecs / 4;
    public static long timeOfLastSpawnedMissile = 0;
    
    // damage made to the opponent
    public static int damagePower = 100;
    
    // missile position
    public int xCoordinate, yCoordinate;
    
    // speed and direction of misile
    private double movingXspeed;
    
    // life-time of smoke
    public long currentSmokeLifeTime;

    // missile image
    public static BufferedImage missileImage;
    

    /**
     * to initialize variables and objects
     */
    public void Initialize(int xCoordinate, int yCoordinate)
    {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        this.movingXspeed = 23;
        
        this.currentSmokeLifeTime = Framework.secsInNanosecs / 2;
    }
    
    
    
    /**
     * to move the missile.
     */
    public void Update()
    {
        xCoordinate += movingXspeed;
    }
    
    
    /**
     * to render the missile on the screen.
     * @param g2d Graphics2D
     */
    public void Draw(Graphics2D g2d)
    {
        g2d.drawImage(missileImage, xCoordinate, yCoordinate, null);
    }
    
    /**
     * to check if the missile has moved out of the screen.
     */
    public boolean isItOutOfScreen()
    {
        if(xCoordinate > 0 && xCoordinate < Framework.frameWidth)
            return false;
        else
            return true;
    }
}
