package helowars;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

/**
 * smoke from the missile's tail 
 * @author Adarshkumar Pavani
 */

public class MissileSmoke {
    
    // x & y co-ordinates of smoke.
    private int xCoordinate, yCoordinate;
    
    // variables or lifetime of smoke
    public long smokeLifeTime, timeOfCreation;
    
    // smoke image
    public static BufferedImage smokeImage;
    
    // set transparency for smooth dissappearing transition of smoke
    public float imageTransparency;
    
    /**
     * Initialize objects
     * @param xCoordinate x coordinate of  missile smoke.
     * @param yCoordinate y coordinate of  missile smoke.
     * @param elapsedGameTime elapsed game time in nanoseconds.
     * @param smokeLifeTime life time of smoke on screen
     */
    public void Initialize(int xCoordinate, int yCoordinate, long elapsedGameTime, long smokeLifeTime)
    {
        this.timeOfCreation = elapsedGameTime;
        
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        this.smokeLifeTime = smokeLifeTime;
                
        this.imageTransparency = 1.0f;
    }
    

    
    /**
     * to check if the smoke has disappeared from the screen
     * @param elapsedGameTime elapsed game time in nanoseconds.
     */
    public boolean didSmokeDisapper(long elapsedGameTime){
        long currentLifeTime = elapsedGameTime - timeOfCreation;
        
        if(currentLifeTime >= smokeLifeTime)
            return true;
        else
            return false;
    }
    
    
    /**
     * render missile smoke on the screen.
     * @param g2d Graphics2D
     */
    public void Draw(Graphics2D g2d)
    {
        g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, imageTransparency));
        
        // adding transparency to make smoke image disappear smoothly
        float imageMultiplier = 2 - imageTransparency;
        int newImageWidth = (int)(smokeImage.getWidth() * imageMultiplier);
        int newImageHeight = (int)(smokeImage.getHeight() * imageMultiplier);
        int newImageYCoordinate = (int)(smokeImage.getHeight()/2 * (1-imageTransparency));
        g2d.drawImage(smokeImage, xCoordinate, yCoordinate - newImageYCoordinate, newImageWidth, newImageHeight, null);
        
        g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER));
    }
    
    
    /**
     * to set new transparency level for the smoke image.
     * @param elapsedGameTime The current elapsed game time in nanoseconds.
     */
    public void updateTransparency(long elapsedGameTime){
        long currentLifeTime = elapsedGameTime - timeOfCreation;
        
        int currentLTInPercentages = (int)(currentLifeTime * 100 / smokeLifeTime);
        currentLTInPercentages = 100 - currentLTInPercentages;
        float mSmokeTransparency = 1.0f * (currentLTInPercentages * 0.01f);

        if(mSmokeTransparency > 0 )
            imageTransparency = mSmokeTransparency;
    }
}
