package helowars;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

/**
 * Opponent Chopper
 * @author Adarshkumar Pavani
 */

public class OpponentChopper {
    
    // For creating new oppenents.
    private static final long timeBetweenNewOpponentsInit = Framework.secsInNanosecs * 3;
    public static long timeBetweenNewOpponents = timeBetweenNewOpponentsInit;
    public static long timeOfLastCreatedOpponent = 0;
    
    // Chopper Health
    public int health;
    
    // chopper position
    public int xCoordinate, yCoordinate;
    
    // speed and direction of motion
    private static final double movingXspeedInit = -4;
    private static double movingXspeed = movingXspeedInit;
    
    // images of oppnent chopper parts
    public static BufferedImage opponentChopperImage, topPropellerImage, backPropellerImage;

    // propeller animation
    private Animation toptPropellerAnimation, backPropellerAnimation;
    // propeller offset (for adjustment)
    private static int offsetXTopPropeller = 4;
    private static int offsetYTopPropeller = -7;
    private static int offsetXBackPropeller = 200;
    private static int offsetYBackPropeller = -16;


    /**
     * Initialize opponent chopper.
     * @param xCoordinate Starting x coordinate of chopper.
     * @param yCoordinate Starting y coordinate of chopper.
     */
    public void Initialize(int xCoordinate, int yCoordinate)
    {
        health = 100;
        
        // opponent position.
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        // Initializing animation
        toptPropellerAnimation = new Animation(topPropellerImage, 158, 16, 3, 20, true, xCoordinate + offsetXTopPropeller, yCoordinate + offsetYTopPropeller, 0);
        backPropellerAnimation = new Animation(backPropellerImage, 47, 47, 10, 5, true, xCoordinate + offsetXBackPropeller, yCoordinate + offsetYBackPropeller, 0);
       
        // opponent speed and direction
        OpponentChopper.movingXspeed = -4;
    }
    
    
    
    
    /**
     * to check if the opponent has left the screen.
     * @return true if the opponent has left the screen, false otherwise.
     */
    public boolean isOutOfScreen()
    {
        if(xCoordinate < 0 - opponentChopperImage.getWidth())
            return true;
        else
            return false;
    }
    
        
    /**
     * to update chopper position, animations.
     */
    public void Update()
    {
        // Move opponent in x direction
        xCoordinate += movingXspeed;
        
        // Move propeller animation with chopper.
        toptPropellerAnimation.changeCoordinates(xCoordinate + offsetXTopPropeller, yCoordinate + offsetYTopPropeller);
        backPropellerAnimation.changeCoordinates(xCoordinate + offsetXBackPropeller, yCoordinate + offsetYBackPropeller);
    }
    
    /**
     * To increase opponent speed and decrease time between new oppenents.
     */
    public static void speedUp(){
        if(OpponentChopper.timeBetweenNewOpponents > Framework.secsInNanosecs)
            OpponentChopper.timeBetweenNewOpponents -= Framework.secsInNanosecs / 100;
        
        OpponentChopper.movingXspeed -= 0.25;
    }
    
    /**
     * Draws chopper with propeller animation to the screen.
     * @param g2d Graphics2D
     */
    public void Draw(Graphics2D g2d)
    { 
        toptPropellerAnimation.Draw(g2d);
        g2d.drawImage(opponentChopperImage, xCoordinate, yCoordinate, null);
        backPropellerAnimation.Draw(g2d);
    }
    
    /**
     * to reset the speed and time between oppenents to the initial properties.
     */
    public static void restartOpponent(){
        OpponentChopper.timeBetweenNewOpponents = timeBetweenNewOpponentsInit;
        OpponentChopper.timeOfLastCreatedOpponent = 0;
        OpponentChopper.movingXspeed = movingXspeedInit;
    }
    
}
