package helowars;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

/**
 * pellet fired from the gun
 * @author Adarshkumar Pavani
 */

public class Pellet {
    
    // to create new pellets.
    public final static long timeBetweenNewPellets = Framework.secsInNanosecs / 10;
    public static long timeOfLastCreatedPellet = 0;
    
    // intensity of damage to opponent
    public static int damagePower = 20;
    
    // pellet position (not a whole number)
    public double xCoordinate;
    public double yCoordinate;
    
    // speed and direction of pellet
    private static int pelletSpeed = 20;
    private double movingXspeed;
    private double movingYspeed;
    
    // pellet image object
    public static BufferedImage pelletImg;
    
    
    /**
     * Constructor for new pellet.
     * @param xCoordinate x coordinate from which the pellet was fired
     * @param yCoordinate y coordinate from which the pellet was fired
     * @param mousePosition object to indicate mouse position at the time of the shot.
     */
    public Pellet(int xCoordinate, int yCoordinate, Point mousePosition)
    {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        setDirectionAndSpeed(mousePosition);
    }
    
    
    /**
     * to calculate the speed on a x and y coordinate.
     * @param mousePosition 
     */
    private void setDirectionAndSpeed(Point mousePosition)
    {	
    	//direction
        double directionVx = mousePosition.x - this.xCoordinate;
        double directionVy = mousePosition.y - this.yCoordinate;
        double lengthOfVector = Math.sqrt(directionVx * directionVx + directionVy * directionVy);
        directionVx = directionVx / lengthOfVector; // Unit vector
        directionVy = directionVy / lengthOfVector; // Unit vector
        
        // Setting speed of motion
        this.movingXspeed = pelletSpeed * directionVx;
        this.movingYspeed = pelletSpeed * directionVy;
    }
    
    
    /**
     * to move the pellet.
     */
    public void Update()
    {
        xCoordinate += movingXspeed;
        yCoordinate += movingYspeed;
    }
    
    /**
     * to check if the pellet has moved out of the screen.
     */
    public boolean isItOutOfScreen()
    {
        if(xCoordinate > 0 && xCoordinate < Framework.frameWidth &&
           yCoordinate > 0 && yCoordinate < Framework.frameHeight)
            return false;
        else
            return true;
    }
    
    
    /**
     * to render the pellet image on the screen.
     * @param g2d Graphics2D
     */
    public void Draw(Graphics2D g2d)
    {
        g2d.drawImage(pelletImg, (int)xCoordinate, (int)yCoordinate, null);
    }
}
