package helowars;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/**
 * Player's chopper
 * @author Adarshkumar Pavani
 */

public class PlayerChopper {
    
    // CHopper health
    private final int healthInit = 100;
    public int health;
    
    // Chopper position
    public int xCoordinate, yCoordinate;
    
    // speed and direction
    private double movingXspeed, acceleratingXspeed, acceleratingYspeed, stoppingXspeed, stoppingYspeed;
    public double movingYspeed;
    // missiles
    private final int numberOfMissilesInit = 80;
    public int numberOfMissiles;
   
    
    // ammo
    private final int numberOfAmmoInit = 1400;
    public int numberOfAmmo;
    
    // Chopper parts images
    public BufferedImage playerChopperImage, topPropellerImage, backPropellerImage;
    
    // propeller animation
    private Animation topPropellerAnimation, backPropellerAnimation;
    
    // offset propeller position (for adjustment)
    private int offsetXTopPropeller, offsetYTopPropeller, offsetXBackPropeller, offsetYBackPropeller;
  
    // offset for missile holder
    private int offsetXMissileHolder, offsetYMissileHolder;
    // missile holder positionwrt chopper
    public int missileHolderXcoordinate, missileHolderYcoordinate;
    
    // offset for gun
    private int offsetXGun, offsetYGun;
    // gun position wrt chopper
    public int gunXcoordinate, gunYcoordinate;
    
    
    /**
     * Constructor for player copper
     * @param xCoordinate: chopper position in x direction
     * @param yCoordinate: chopper position in y direction
     */
    public PlayerChopper(int xCoordinate, int yCoordinate)
    {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        loadContent();
        initialize();
    }
    
    
    /**
     * For setting variables and objects
     */
    private void initialize()
    {
        this.health = healthInit;
        
        this.numberOfMissiles = numberOfMissilesInit;
        this.numberOfAmmo = numberOfAmmoInit;
        
        this.movingXspeed = 0;
        this.movingYspeed = 0;
        this.acceleratingXspeed = 0.2;
        this.acceleratingYspeed = 0.2;
        this.stoppingXspeed = 0.1;
        this.stoppingYspeed = 0.1;

        this.offsetXTopPropeller = 63;
        this.offsetYTopPropeller = -27;        
        this.offsetXBackPropeller = -14;
        this.offsetYBackPropeller = -17;
        
        this.offsetXMissileHolder = 138;
        this.offsetYMissileHolder = 40;
        this.missileHolderXcoordinate = this.xCoordinate + this.offsetXMissileHolder;
        this.missileHolderYcoordinate = this.yCoordinate + this.offsetYMissileHolder;
        
        this.offsetXGun = playerChopperImage.getWidth() - 40;
        this.offsetYGun = playerChopperImage.getHeight();
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
    }
    
    /**
     * For Loading content
     */
    private void loadContent()
    {
        try 
        {
            URL playerChopperPath = this.getClass().getResource("/helowars/resources/player_chopper_body.png");
            playerChopperImage = ImageIO.read(playerChopperPath);
            
            URL topPropellerPath = this.getClass().getResource("/helowars/resources/player_top_propeller_animation.png");
            topPropellerImage = ImageIO.read(topPropellerPath);
            
            URL backPropellerPath = this.getClass().getResource("/helowars/resources/player_back_propeller_animation.png");
            backPropellerImage = ImageIO.read(backPropellerPath);
        } 
        catch (IOException ex) {
            Logger.getLogger(PlayerChopper.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        // INitializing animation parameters
        topPropellerAnimation = new Animation(topPropellerImage, 204, 34, 3, 20, true, xCoordinate + offsetXTopPropeller, yCoordinate + offsetYTopPropeller, 0);
        backPropellerAnimation = new Animation(backPropellerImage, 54, 54, 4, 20, true, xCoordinate + offsetXBackPropeller, yCoordinate + offsetYBackPropeller, 0);
    }
    
    
    /**
     * to check if player is firing. To check the time between bullets and if ammo is empty
     * @param gameTime The current elapsed game time in nanoseconds.
     * @return true if player is shooting.
     */
    public boolean isFiring(long gameTime)
    {
        // fires new pellet if left mouse button is down
        if( UserInputControl.mouseButtonState(MouseEvent.BUTTON1) && 
            ((gameTime - Pellet.timeOfLastCreatedPellet) >= Pellet.timeBetweenNewPellets) &&
            this.numberOfAmmo > 0) 
        {
            return true;
        } else
            return false;
    }
    
    
    /**
     * to check if player can fire a missile
     * @param gameTime The current elapsed game time in nanoseconds.
     * @return true if player is fired a missile.
     */
    public boolean isFiredMissile(long gameTime)
    {
        // fires missile at appropriate time on right click
        if( UserInputControl.mouseButtonState(MouseEvent.BUTTON3) && 
            ((gameTime - Missile.timeOfLastSpawnedMissile) >= Missile.timeBetweenNewMissiles) && 
            this.numberOfMissiles > 0 ) 
        {
            return true;
        } else
            return false;
    }
    
    
    /**
     * for sensing keypress and moving chopper accordingly
     */
    public void isMoving()
    {
    	// move in x direction
        if(UserInputControl.keyboardKeyState(KeyEvent.VK_D) || UserInputControl.keyboardKeyState(KeyEvent.VK_RIGHT))
            movingXspeed += acceleratingXspeed;
        else if(UserInputControl.keyboardKeyState(KeyEvent.VK_A) || UserInputControl.keyboardKeyState(KeyEvent.VK_LEFT))
            movingXspeed -= acceleratingXspeed;
        else    // Stopping
            if(movingXspeed < 0)
                movingXspeed += stoppingXspeed;
            else if(movingXspeed > 0)
                movingXspeed -= stoppingXspeed;
        
    	// move in y direction

        if(UserInputControl.keyboardKeyState(KeyEvent.VK_W) || UserInputControl.keyboardKeyState(KeyEvent.VK_UP))
            movingYspeed -= acceleratingYspeed;
        else if(UserInputControl.keyboardKeyState(KeyEvent.VK_S) || UserInputControl.keyboardKeyState(KeyEvent.VK_DOWN))
            movingYspeed += acceleratingYspeed;
        else    // Stoping
            if(movingYspeed < 0)
                movingYspeed += stoppingYspeed;
            else if(movingYspeed > 0)
                movingYspeed -= stoppingYspeed;
    }
    
    
    /**
     * to update position of chopper, animations.
     */
    public void Update()
    {
        // to move chopper and its propellers.
        xCoordinate += movingXspeed;
        yCoordinate += movingYspeed;
        topPropellerAnimation.changeCoordinates(xCoordinate + offsetXTopPropeller, yCoordinate + offsetYTopPropeller);
        backPropellerAnimation.changeCoordinates(xCoordinate + offsetXBackPropeller, yCoordinate + offsetYBackPropeller);
        
        // adjust position of the missile holder.
        this.missileHolderXcoordinate = this.xCoordinate + this.offsetXMissileHolder;
        this.missileHolderYcoordinate = this.yCoordinate + this.offsetYMissileHolder;
        
        // moving the gun with chopper.
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
    }
    
    
    /**
     * to render the assembled chopper parts on the screen.
     * @param g2d Graphics2D
     */
    public void Draw(Graphics2D g2d)
    {
        topPropellerAnimation.Draw(g2d);
        backPropellerAnimation.Draw(g2d);
        g2d.drawImage(playerChopperImage, xCoordinate, yCoordinate, null);
    }
    
    /**
     * Resets the player
     */
    public void Reset(int xCoordinate, int yCoordinate)
    {
        this.health = healthInit;
        
        this.numberOfMissiles = numberOfMissilesInit;
        this.numberOfAmmo = numberOfAmmoInit;
        
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        
        this.gunXcoordinate = this.xCoordinate + this.offsetXGun;
        this.gunYcoordinate = this.yCoordinate + this.offsetYGun;
        
        this.movingXspeed = 0;
        this.movingYspeed = 0;
    }
    
}
