package helowars;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

/**
 * Develop a JPanel to draw and listen for keyboard / mouse events.
 * @author Adarshkumar Pavani
 */

public abstract class UserInputControl extends JPanel implements KeyListener, MouseListener {
    
    // to store keyboard states (pressed / unpressed state)
    private static boolean[] keyboardState = new boolean[525];
    
    // to store mouse states (pressed / unpressed state)
    private static boolean[] mouseState = new boolean[3];
        
    //Constructor
    public UserInputControl()
    {
    	this.setDoubleBuffered(true);
        this.setFocusable(true);
        this.setBackground(Color.black);
        
        // inserting "true" to remove the default mouse cursor
        if(true)
        {
            BufferedImage blankCursorImg = new BufferedImage(16, 16, BufferedImage.TYPE_INT_ARGB);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(blankCursorImg, new Point(0, 0), null);
            this.setCursor(blankCursor);
        }
        
        // adding the keyboard listener to JPanel to receive key events
        this.addKeyListener(this);
        // adding the mouse listener to JPanel to receive mouse events
        this.addMouseListener(this);
    }
    
    
    
    // Keyboard
    /**
     * to get the state of the key pressed (i.e. whether it is "up" / "down") 
     * @param key Number of key for which you want to check the state.
     * @return true if the key is down or false otherwise
     */
    public static boolean keyboardKeyState(int key)
    {
        return keyboardState[key];
    }
    
    // methods of the keyboard listener.
    @Override
    public void keyPressed(KeyEvent e) 
    {
        keyboardState[e.getKeyCode()] = true;
    }
    
    @Override
    public void keyReleased(KeyEvent e)
    {
        keyboardState[e.getKeyCode()] = false;
        keyReleasedFramework(e);
    }
    
    @Override
    public void keyTyped(KeyEvent e) { }
    
    public abstract void keyReleasedFramework(KeyEvent e);
    
    
    // Mouse
    /**
     * to get state of the passsed mouse key
     * @param button Number of mouse button for which you want to check the state. eg: "MouseEvent.BUTTON1" or "MouseEvent.BUTTON2" for LMB and RMB respectively
     * @return true if the button is down or false otherwise
     */
    public static boolean mouseButtonState(int button)
    {
        return mouseState[button - 1];
    }
    
    // to set status of mouse key
    private void mouseKeyStatus(MouseEvent e, boolean status)
    {
        if(e.getButton() == MouseEvent.BUTTON1)
            mouseState[0] = status;
        else if(e.getButton() == MouseEvent.BUTTON2)
            mouseState[1] = status;
        else if(e.getButton() == MouseEvent.BUTTON3)
            mouseState[2] = status;
    }
    
    // methods of the mouse listener.
    @Override
    public void mousePressed(MouseEvent e)
    {
        mouseKeyStatus(e, true);
    }
    
    @Override
    public void mouseReleased(MouseEvent e)
    {
        mouseKeyStatus(e, false);
    }
    
    @Override
    public void mouseClicked(MouseEvent e) { }
    
    @Override
    public void mouseEntered(MouseEvent e) { }
    
    @Override
    public void mouseExited(MouseEvent e) { }
    
    
    // this method is overridden in Framework.java and is used for drawing images on the screen.
    public abstract void Draw(Graphics2D g2d);
    
    @Override
    public void paintComponent(Graphics g)
    {
        Graphics2D g2d = (Graphics2D)g;        
        super.paintComponent(g2d);        
        Draw(g2d);
    }
    
}
