/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class NumberPuzzleUI
extends Frame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Button[] buttons = new Button[16];
    private Panel numberGrid = new Panel();
    private Button shuffle = new Button("Shuffle");
    private int empty = 15;
    private boolean gameWon = false;
    private NumberPuzzleControl control;

    public NumberPuzzleUI(NumberPuzzleControl control) {
        this.control = control;
        this.initializeComponents(control);
    }

    private void initializeComponents(NumberPuzzleControl control) {
        this.add((Component)this.numberGrid, "Center");
        this.numberGrid.setLayout(new GridLayout(4, 4));
        int i = 0;
        while (i < 16) {
            this.buttons[i] = new Button();
            this.numberGrid.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
            ++i;
        }
        this.shuffle.setFont(new Font("Arial", 1, control.getShuffleButtonFontSize()));
        this.add((Component)this.shuffle, "South");
        this.shuffle.addActionListener(this);
        this.setWindowProperties(control);
        this.setWindowClosingProperty();
        this.shuffleGrid();
        this.setVisible(true);
    }

    private void setWindowClosingProperty() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
    }

    private void setWindowProperties(NumberPuzzleControl control) {
        this.setSize(control.getWidth(), control.getHeight());
        this.setLocation(control.getXPosition(), control.getYPosition());
        this.setResizable(false);
        this.setTitle(control.getTitle());
    }

    private void shuffleGrid() {
        int i;
        if (this.gameWon) {
            i = 0;
            while (i < 16) {
                this.buttons[i].addActionListener(this);
                ++i;
            }
        }
        i = 0;
        while (i < 16) {
            this.buttons[i].setBackground(Color.lightGray);
            ++i;
        }
        this.buttons[15].setLabel("  ");
        this.buttons[15].setBackground(this.control.getEmptyButtonColor());
        int[] arr = this.control.getRandomNumbersForGrid();
        int i2 = 0;
        while (i2 < 15) {
            this.buttons[i2].setLabel(String.valueOf(arr[i2]));
            this.buttons[i2].setFont(new Font("Arial", 1, this.control.getNumbersFontSize()));
            ++i2;
        }
        this.empty = 15;
    }

    private void checkForWinner() {
        boolean winner = this.control.checkForWinner(this.buttons);
        if (winner) {
            int i = 0;
            while (i < 15) {
                this.buttons[i].removeActionListener(this);
                ++i;
            }
            MessageDialog dialog = new MessageDialog((Frame)this, true);
            dialog.setMessage(this.control.getWinnerMessage());
            dialog.setVisible(true);
            this.gameWon = true;
        }
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        Button b = (Button)ae.getSource();
        if (b == this.shuffle) {
            this.shuffleGrid();
        } else {
            NumberPuzzleGame game = new NumberPuzzleGame(this.empty, b, this.buttons);
            this.empty = this.control.handleButtonClicked(game);
        }
        if (this.empty == 15) {
            this.checkForWinner();
        }
    }
}

